/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class IonEnthalpy
extends JScrollPane
implements IPanelListener,
ActionListener {
    private PropertyPanelManager ppmgr;
    private JTable j = new JTable();
    private JMenuItem miCopyToClipboard = new JMenuItem("Copy to Clipboard...", 67);
    private JMenuItem miPrintGraph = new JMenuItem("Print Text...", 80);
    private JMenu pmContext = new JCoolMenu("Panel");

    public String toString() {
        return "Ionization Enthalpies";
    }

    public IonEnthalpy(ConfigManager configManager, PropertyPanelManager propertyPanelManager) {
        this.ppmgr = propertyPanelManager;
        Font font = this.j.getFont();
        this.j.setFont(new Font(font.getName(), 0, 20));
        this.j.setRowHeight(this.j.getRowHeight() + 10);
        this.j.setSelectionMode(0);
        this.j.setCellSelectionEnabled(false);
        this.setViewportView(this.j);
        if (configManager.canGetClipboard()) {
            this.miCopyToClipboard.addActionListener(this);
            this.miCopyToClipboard.setActionCommand("CopyToClipboard");
            this.pmContext.add(this.miCopyToClipboard);
        }
        if (configManager.canPrint()) {
            this.miPrintGraph.addActionListener(this);
            this.miPrintGraph.setActionCommand("FilePrintText");
            this.pmContext.add(this.miPrintGraph);
        }
        this.pmContext.setMnemonic('P');
    }

    public void setAtom(PanelEvent panelEvent) {
        TElement tElement = panelEvent.getElement();
        float[] fArray = tElement.enthalpies;
        String[] stringArray = new String[]{"Electron", "Enthalpy (kJ/mol)"};
        1 var5_5 = new 1(stringArray, 0);
        int n = 0;
        while (n < fArray.length) {
            Object[] objectArray = new Object[]{new Integer(n), new Float(fArray[n])};
            var5_5.addRow(objectArray);
            ++n;
        }
        this.j.setModel(var5_5);
        this.j.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("CopyToClipboard")) {
            this.OnCopyToClipboard();
            return;
        }
        string.equals("FilePrintText");
    }

    private void OnCopyToClipboard() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.j.getRowCount();
        int n2 = this.j.getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(this.j.getColumnName(n3));
            ++n3;
        }
        stringBuffer.append("\r\n");
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                stringBuffer.append(this.j.getValueAt(n4, n5).toString());
                stringBuffer.append("\t");
                ++n5;
            }
            stringBuffer.append("\r\n");
            ++n4;
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    public void onActivate(PanelEvent panelEvent) {
        this.ppmgr.addMenu(this.pmContext);
    }

    public void onDeactivate(PanelEvent panelEvent) {
        this.ppmgr.removeMenu(this.pmContext);
    }

    private void OnFilePrintText() {
    }

    public void setStyle(PanelEvent panelEvent) {
    }

    public void updateUI() {
        super.updateUI();
        if (this.pmContext != null) {
            this.pmContext.updateUI();
        }
    }

    private final class 1
    extends DefaultTableModel {
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        /* synthetic */ 1(String[] stringArray, int n) {
            super(stringArray, n);
        }
    }
}

