/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextPanel
extends JPanel
implements IPanelListener,
ActionListener {
    private JLabel lCaption;
    private JTextArea lContent;
    private String sCaption;
    private PropertyPanelManager ppmgr;
    private PropertyPanelScript script;
    private int index = -1;
    private JMenuItem miCopyToClipboard = new JMenuItem("Copy to Clipboard...", 67);
    private JMenuItem miPrintGraph = new JMenuItem("Print Text...", 80);
    private JMenu pmContext = new JCoolMenu("Panel");

    public String toString() {
        return this.sCaption;
    }

    public TextPanel(PropertyPanelScript propertyPanelScript, int n, String string, PropertyPanelManager propertyPanelManager, ConfigManager configManager) {
        this.index = n;
        this.sCaption = string;
        this.ppmgr = propertyPanelManager;
        this.script = propertyPanelScript;
        this.lCaption = new JLabel(this.sCaption);
        this.setLayout(new BorderLayout());
        this.add("North", this.lCaption);
        this.lContent = new JTextArea("????");
        this.lContent.setLineWrap(true);
        this.lContent.setWrapStyleWord(true);
        Font font = this.lContent.getFont();
        this.lContent.setFont(new Font("Arial", font.getStyle(), 36));
        this.lContent.setBackground(this.getBackground());
        this.lContent.setBorder(null);
        this.lContent.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.lContent);
        this.add("Center", jScrollPane);
        if (configManager.canGetClipboard()) {
            this.miCopyToClipboard.addActionListener(this);
            this.miCopyToClipboard.setActionCommand("CopyToClipboard");
            this.pmContext.add(this.miCopyToClipboard);
        }
        if (configManager.canPrint()) {
            this.miPrintGraph.addActionListener(this);
            this.miPrintGraph.setActionCommand("FilePrintText");
            this.pmContext.add(this.miPrintGraph);
        }
        this.pmContext.setMnemonic('P');
    }

    public void setAtom(PanelEvent panelEvent) {
        this.lContent.setText(this.script.getTextPanelData(this.index, panelEvent.getElement()));
    }

    public void onActivate(PanelEvent panelEvent) {
        this.ppmgr.addMenu(this.pmContext);
    }

    public void onDeactivate(PanelEvent panelEvent) {
        this.ppmgr.removeMenu(this.pmContext);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (!string.equals("FilePrintText") && string.equals("CopyToClipboard")) {
            this.OnCopyToClipboard();
        }
    }

    private void OnFilePrintText() {
    }

    private void OnCopyToClipboard() {
        StringSelection stringSelection = new StringSelection(this.lContent.getText());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    public void setStyle(PanelEvent panelEvent) {
    }

    public void updateUI() {
        super.updateUI();
        if (this.pmContext != null) {
            this.pmContext.updateUI();
        }
    }
}

