/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

class DatabaseManager {
    private IOManager iomgr;
    public static final String ElementsDB = "Elements.dat";
    public static final String EnthalpyDB = "Enthalpy.dat";
    public static final String LayoutDB = "Layout.dat";
    public static final String ClassesDB = "Class.dat";
    public static final String StatesDB = "State.dat";
    public static final String TypesDB = "Types.dat";
    private Map elements;
    private List layout;
    private Map classes;
    private Map states;
    private Map types;
    private LoadStatusManager lsmgr;
    private ConfigManager cfgmgr;

    public DatabaseManager(LoadStatusManager loadStatusManager, IOManager iOManager, ConfigManager configManager) {
        this.iomgr = iOManager;
        this.lsmgr = loadStatusManager;
        this.cfgmgr = configManager;
        try {
            loadStatusManager.setProgress("Reading atomic database...");
            this.elements = this.getElements(this.iomgr.getInputStream(ElementsDB), this.iomgr.getInputStream(EnthalpyDB));
            loadStatusManager.setProgress("Reading table layout...");
            this.layout = this.getLayout(this.iomgr.getInputStream(LayoutDB));
            loadStatusManager.setProgress("Reading classes...");
            this.classes = this.getClasses(this.iomgr.getInputStream(ClassesDB));
            loadStatusManager.setProgress("Reading states...");
            this.states = this.getStates(this.iomgr.getInputStream(StatesDB));
            loadStatusManager.setProgress("Reading element types...");
            this.types = this.getTypes(this.iomgr.getInputStream(TypesDB));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private float[] decodeEnthalpies(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
        stringTokenizer.nextToken();
        int n = stringTokenizer.countTokens();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = Float.valueOf(stringTokenizer.nextToken()).floatValue();
            ++n2;
        }
        return fArray;
    }

    public final Map getClasses() {
        return this.classes;
    }

    private Map getClasses(InputStream inputStream) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        HashMap<Integer, TClass> hashMap = new HashMap<Integer, TClass>();
        bufferedReader.readLine();
        while ((string = bufferedReader.readLine()) != null) {
            TClass tClass = TClass.decode(string);
            hashMap.put(new Integer(tClass.number), tClass);
        }
        inputStream.close();
        return hashMap;
    }

    public TElement getElement(int n) {
        return (TElement)this.elements.get(new Integer(n));
    }

    public final Map getElements() {
        return this.elements;
    }

    private Map getElements(InputStream inputStream, InputStream inputStream2) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2));
        HashMap<Integer, TElement> hashMap = new HashMap<Integer, TElement>();
        String string = bufferedReader.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
        int n = stringTokenizer.countTokens();
        bufferedReader2.readLine();
        int n2 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (++n2 % 10 == 0) {
                this.lsmgr.setProgress("Reading element " + n2 + "...");
            }
            TElement tElement = TElement.decode(string, n);
            tElement.enthalpies = this.decodeEnthalpies(bufferedReader2.readLine());
            hashMap.put(new Integer(tElement.AtomicNumber), tElement);
        }
        inputStream.close();
        inputStream2.close();
        return hashMap;
    }

    public final List getLayout() {
        return this.layout;
    }

    private List getLayout(InputStream inputStream) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>(120);
        String string = bufferedReader.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
        arrayList.add(stringTokenizer.nextToken());
        arrayList.add(stringTokenizer.nextToken());
        while ((string = bufferedReader.readLine()) != null) {
            stringTokenizer = new StringTokenizer(string, "\t", false);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        inputStream.close();
        return arrayList;
    }

    public final Map getStates() {
        return this.states;
    }

    private Map getStates(InputStream inputStream) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        HashMap<Integer, TState> hashMap = new HashMap<Integer, TState>();
        bufferedReader.readLine();
        while ((string = bufferedReader.readLine()) != null) {
            TState tState = TState.decode(string);
            hashMap.put(new Integer(tState.number), tState);
        }
        inputStream.close();
        return hashMap;
    }

    public final Map getTypes() {
        return this.types;
    }

    private Map getTypes(InputStream inputStream) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        HashMap<Integer, TElementType> hashMap = new HashMap<Integer, TElementType>();
        bufferedReader.readLine();
        while ((string = bufferedReader.readLine()) != null) {
            TElementType tElementType = TElementType.decode(string);
            hashMap.put(new Integer(tElementType.number), tElementType);
        }
        inputStream.close();
        return hashMap;
    }

    public void saveEverything(DataOutputStream dataOutputStream) throws IOException {
        Iterator iterator = this.elements.values().iterator();
        while (iterator.hasNext()) {
            dataOutputStream.writeBytes(AllElementInfo.getAtomInfoAsText((TElement)iterator.next(), this));
            dataOutputStream.writeBytes(this.cfgmgr.getCrlf());
            dataOutputStream.writeBytes(this.cfgmgr.getCrlf());
            dataOutputStream.writeBytes("======================================");
            dataOutputStream.writeBytes(this.cfgmgr.getCrlf());
            dataOutputStream.writeBytes(this.cfgmgr.getCrlf());
        }
    }
}

