/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;

class atom {
    int AtomicNumber = -1;
    int mass = 1;
    int width = 100;
    int height = 100;
    double radius = 100.0;
    Electron[] electrons = null;
    int max_Electron = 0;
    int electron_size;
    int nucleon_size;
    int start = 1;
    int iRadius;

    atom() {
        this.init();
    }

    atom(int n, int n2, int n3, int n4) {
        this.AtomicNumber = n;
        this.mass = n2;
        this.height = n4;
        this.width = n3;
        this.radius = Math.min(this.height, this.width);
        this.iRadius = Math.min(this.height, this.width);
        this.init();
    }

    public void draw(Graphics2D graphics2D, int n, int n2) {
        int n3 = 0;
        while (n3 < this.max_Electron) {
            graphics2D.draw(new Ellipse2D.Double((double)n - this.electrons[n3].radius, (double)n2 - this.electrons[n3].radius, 2.0 * this.electrons[n3].radius, 2.0 * this.electrons[n3].radius));
            this.electrons[n3].draw(graphics2D, n, n2);
            ++n3;
        }
        graphics2D.setColor(Color.red);
        graphics2D.fill(new Ellipse2D.Double(n - this.nucleon_size / 2, n2 - this.nucleon_size / 2, this.nucleon_size, this.nucleon_size));
    }

    public void init() {
        this.electrons = new Electron[7];
        this.AtomicNumber = Math.max(1, Math.min(this.AtomicNumber, 118));
        this.initSystem();
        this.nucleon_size = Math.min((int)(this.radius / 7.0 / 2.0), 25);
    }

    private void initSystem() {
        int n = this.AtomicNumber;
        this.setAtomicNumber(118);
        this.setAtomicNumber(n);
    }

    public void setAtomicNumber(int n) {
        int n2;
        int n3;
        if (this.AtomicNumber == n) {
            return;
        }
        this.AtomicNumber = n;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < 7) {
            n3 = 0;
            n2 = 0;
            while (n2 <= n7) {
                n3 += -2 + (n2 + 1) * 4;
                ++n2;
            }
            this.electrons[n7] = new Electron(this, n3, 0.0, 0.1);
            ++n7;
        }
        while (n6 < n) {
            if (n4 == 0) {
                n4 = 1;
                n5 = 1;
            } else if (n5 > 1) {
                ++n4;
                --n5;
            } else {
                n2 = n4;
                n4 = (n4 + 1) / 2 + 1;
                n5 = n2 / 2 + 1;
            }
            n3 = -2 + n5 * 4;
            this.max_Electron = Math.max(n4, this.max_Electron);
            while (n6 < n && n3 > 0) {
                ++this.electrons[n4 - 1].actual;
                ++n6;
                --n3;
            }
        }
        n6 = 0;
        while (n6 < this.max_Electron) {
            this.electrons[n6].set_settings(0.9 * this.radius / (double)(this.max_Electron - n6) / 2.0, Math.min((int)(this.radius / (double)(this.max_Electron * this.max_Electron) * 1.5), 8));
            ++n6;
        }
    }
}

