/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class JSystemInfo
extends JScrollPane
implements ActionListener {
    private JTextArea ta = new JTextArea();

    public JSystemInfo() {
        this.setViewportView(this.ta);
        this.ta.setEditable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension(dimension.width / 2, dimension.height / 2));
        this.refresh();
    }

    public void refresh() {
        Object object;
        Object object2;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = toolkit.getScreenResolution();
        Dimension dimension = toolkit.getScreenSize();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Screen Resolution (in dpi): ");
        stringBuffer.append(String.valueOf(n));
        stringBuffer.append(" Screen size: " + dimension.width + "x" + dimension.height + "\n");
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        stringBuffer.append("Fonts Available:\n");
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringBuffer.append("     \"" + stringArray[n2] + "\"\n");
            ++n2;
        }
        long l = System.currentTimeMillis();
        stringBuffer.append("It has been " + l + " milliseconds since January 1st, 1970\n");
        try {
            stringBuffer.append("System Properties:\n");
            stringBuffer.append("     Java version: " + System.getProperty("java.version") + "\n");
            stringBuffer.append("     Java vendor: " + System.getProperty("java.vendor") + "\n");
            stringBuffer.append("     Java vendor's URL: " + System.getProperty("java.vendor.url") + "\n");
            stringBuffer.append("     Home Java folder: " + System.getProperty("java.home") + "\n");
            stringBuffer.append("     Java class version: " + System.getProperty("java.class.version") + "\n");
            stringBuffer.append("     Java class path: " + System.getProperty("java.class.path") + "\n");
            stringBuffer.append("     Operating System: " + System.getProperty("os.name") + "\n");
            stringBuffer.append("     Operating system architecture: " + System.getProperty("os.arch") + "\n");
            stringBuffer.append("     Operating system version: " + System.getProperty("os.version") + "\n");
            stringBuffer.append("     File separator: " + System.getProperty("file.separator") + "\n");
            stringBuffer.append("     Path separator: " + System.getProperty("path.separator") + "\n");
            stringBuffer.append("     User name: " + System.getProperty("user.name") + "\n");
            stringBuffer.append("     User's home directory: " + System.getProperty("user.home") + "\n");
            stringBuffer.append("     Current working directory: " + System.getProperty("user.dir") + "\n");
            stringBuffer.append("File Properties:\n");
            stringBuffer.append("     Path Separator String: " + File.pathSeparator + "\n");
            stringBuffer.append("     Path Separator char: " + File.pathSeparatorChar + "\n");
            stringBuffer.append("     Separator String: " + File.separator + "\n");
            stringBuffer.append("     Separator char: " + File.separatorChar + "\n");
        }
        catch (Exception exception) {}
        stringBuffer.append("System Memory Information:\n");
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        stringBuffer.append("     Free memory: " + runtime.freeMemory() + " bytes\n");
        stringBuffer.append("     Total memory: " + runtime.totalMemory() + " bytes\n");
        stringBuffer.append("     Memory in use: " + (runtime.totalMemory() - runtime.freeMemory()) + " bytes\n");
        try {
            stringBuffer.append("Dump of all defined properties:\n");
            object2 = System.getProperties();
            object = ((Properties)object2).propertyNames();
            while (object.hasMoreElements()) {
                try {
                    String string = (String)object.nextElement();
                    if (string.equals("line.separator")) continue;
                    stringBuffer.append("     \"" + string + "\" = \"" + System.getProperty(string) + "\"\n");
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        object2 = System.getProperty("line.separator");
        object = "";
        int n3 = 0;
        while (n3 < ((String)object2).length()) {
            char c = ((String)object2).charAt(n3);
            object = c == '\r' ? String.valueOf(object) + "\\r" : (c == '\n' ? String.valueOf(object) + "\\n" : String.valueOf(object) + c);
            ++n3;
        }
        stringBuffer.append("     \"line.separator\" = \"" + (String)object + "\"\n");
        try {
            stringBuffer.append("Dump of Swing properties:\n");
            this.getClass();
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", null);
            Hashtable hashtable = (Hashtable)method.invoke(null, null);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                stringBuffer.append("     \"" + k + "\" = \"" + hashtable.get(k) + "\"\n");
            }
        }
        catch (Exception exception) {}
        stringBuffer.append("=== End of output ===\n");
        this.ta.setText(stringBuffer.toString());
        toolkit.beep();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Refresh")) {
            this.refresh();
        }
    }
}

