import javax.swing.*;
import java.awt.event.*;

class MenuManager implements ActionListener {
   private ConfigManager cfgmgr;
   private LoadStatusManager lsmgr;
   private JMenuBar jmb = null;
   private JPeriod99 parent;
   private PropertyPanelManager ppmgr;
   private JMenuBar mb;

   private int style =
       PanelEvent.GS_LOCATOR |
       PanelEvent.GS_STICKYLOCATOR |
       PanelEvent.GS_OPAQUECOORDS;

   //menu
   private JMenuItem
       miFileSaveElement = new JMenuItem("Save Element...", 'S'),
       miFileSaveAll = new JMenuItem("Save All Elements...", 'A'),
       miFileSaveDatabase = new JMenuItem("Save Database...", 'D'),
       miFilePrintEverything = new JMenuItem("Print Everything...", 'E'),
       miFileExit = new JMenuItem("Exit", 'x'),
       miHelpAbout = new JMenuItem("About...", 'A'),
       miHelpAboutVM = new JMenuItem("About Java VM...", 'V');

   private JCheckBoxMenuItem
       cmiGraphsInterpolate = new JCheckBoxMenuItem("Interpolate Missing Points", false),
       cmiGraphsDrawLocator = new JCheckBoxMenuItem("Draw Locator", true),
       cmiGraphsFollowCurve = new JCheckBoxMenuItem("Locator Follows Curve", true),
       cmiOpaqueCoords = new JCheckBoxMenuItem("Opaque Coordinates", true),
       cmiTableOnForm = new JCheckBoxMenuItem("Table on Main Window", true),
       cmiPropListOnForm = new JCheckBoxMenuItem("Property List on Main Window", true);

   private JRadioButtonMenuItem
       rmiColorsColor = new JRadioButtonMenuItem("Color", true),
       rmiColorsMono = new JRadioButtonMenuItem("Monochrome", false);

   private JCoolMenu mFile = new JCoolMenu("File"),
       mColors = new JCoolMenu("Colors"),
       mAppearance = new JCoolMenu("Appearance"),
       mGraphs = new JCoolMenu("Graphs"),
       mTable = new JCoolMenu("Table"),
       mHelp = new JCoolMenu("Help");

   public MenuManager(LoadStatusManager l, ConfigManager c, JPeriod99 p, PropertyPanelManager pp) {
       cfgmgr = c;
       lsmgr = l;
       parent = p;
       ppmgr = pp;
   }

   private void initMenuItem(JCoolMenu mp, JMenuItem mi, char accel, String action) {
       mi.addActionListener(this);
       mi.setActionCommand(action);
       mi.setMnemonic(accel);
       mp.add(mi);
   }

   private JMenuBar initMenus() {
       lsmgr.setProgress("Creating \"File\" menu...");
       if(cfgmgr.canWriteFiles()) {
           //if we got to here, we can save files...
           initMenuItem(mFile, miFileSaveElement, 'S', "FileSave");
           initMenuItem(mFile, miFileSaveAll, 'A', "FileSaveAll");
           initMenuItem(mFile, miFileSaveDatabase, 'D', "FileSaveDBase");
       }
       mFile.add(new JSeparator());
       if(cfgmgr.canPrint()) {
           initMenuItem(mFile, miFilePrintEverything, 'E', "FilePrintEverything");
       }
       if(!cfgmgr.canExitVM()) {
           miFileExit.setText("Close");
           miFileExit.setMnemonic('C');
       }
       miFileExit.addActionListener(this);
       miFileExit.setActionCommand("FileExit");
       mFile.add(miFileExit);
       mFile.setMnemonic('F');

       lsmgr.setProgress("Creating \"Colors\" menu...");
       ButtonGroup bg = new ButtonGroup();

       initMenuItem(mColors, rmiColorsColor, 'C', "ColorsColor");
       bg.add(rmiColorsColor);
       initMenuItem(mColors, rmiColorsMono, 'M', "ColorsMono");
       bg.add(rmiColorsMono);

       lsmgr.setProgress("Creating \"Appearance\" menu...");
       mAppearance.setMnemonic('A');
       bg = new ButtonGroup();

       LookAndFeel laf = UIManager.getLookAndFeel();

       //but what about com.sun.java.swing.plaf.mac.MacLookAndFeel?
       boolean bMacLookFound = false;
       try {
           getClass().forName("javax.swing.plaf.mac.MacLookAndFeel");
           UIManager.installLookAndFeel("Macintosh", "javax.swing.plaf.mac.MacLookAndFeel");
           bMacLookFound = true;
       } catch (ClassNotFoundException e) {}

       if(!bMacLookFound) {
           try {
               getClass().forName("com.sun.java.swing.plaf.mac.MacLookAndFeel");
               UIManager.installLookAndFeel("Macintosh", "com.sun.java.swing.plaf.mac.MacLookAndFeel");
           } catch (ClassNotFoundException e) {}
       }

       UIManager.LookAndFeelInfo lafi[] = UIManager.getInstalledLookAndFeels();
       for(int i = 0; i < lafi.length;i++) {
           JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem(lafi[i].getName(), (laf.getName().equals(lafi[i].getName())));
           rbmi.addActionListener(this);
           rbmi.setActionCommand(lafi[i].getClassName());
           bg.add(rbmi);
           mAppearance.add(rbmi);
       }

       mColors.setMnemonic('C');

       lsmgr.setProgress("Creating \"Graphs\" menu...");
       initMenuItem(mGraphs, cmiGraphsInterpolate, 'I', "GraphsInterpolate");
       initMenuItem(mGraphs, cmiGraphsDrawLocator, 'L', "GraphsDrawLocator");
       initMenuItem(mGraphs, cmiGraphsFollowCurve, 'F', "GraphsFollowCurve");
       initMenuItem(mGraphs, cmiOpaqueCoords, 'O', "OpaqueCoords");
       mGraphs.setMnemonic('G');

       lsmgr.setProgress("Creating \"Table\" menu...");
       initMenuItem(mTable, cmiTableOnForm, 'T', "AtomicTableOnForm");
       initMenuItem(mTable, cmiPropListOnForm, 'P', "PropTreeOnForm");
       mTable.setMnemonic('T');

       lsmgr.setProgress("Creating \"Help\" menu...");
       initMenuItem(mHelp, miHelpAboutVM, 'V', "HelpAboutVM");
       initMenuItem(mHelp, miHelpAbout, 'A', "HelpAbout");
       mHelp.setMnemonic('H');

       mb = new JMenuBar();
       mb.add(mFile);
//       mb.add(mColors);
       mb.add(mAppearance);
       mb.add(mGraphs);
       mb.add(mTable);
       mb.add(mHelp);

       mb.setBorder(null);

       return mb;
   }

   public JMenuBar getMenuBar() {
       if(jmb == null) jmb = initMenus();
       return jmb;
   }

   public void actionPerformed(ActionEvent e){
       String s = e.getActionCommand();

       //File Menu handlers
       if(s.equals("FileSave")) {
           parent.OnFileSave();
       } else if(s.equals("FileSaveAll")){
           parent.OnFileSaveAll();
       } else if(s.equals("FileSaveDBase")){
           parent.OnFileSaveDatabase();
       } else if(s.equals("FilePrintEverything")){
           parent.OnFilePrintEverything();
       } else if(s.equals("FileExit")){
           parent.dispose();
           if(cfgmgr.canExitVM()) System.exit(0);
           else {
               parent.makeWindowEvent(new WindowEvent(parent, WindowEvent.WINDOW_CLOSING));
           }

       //Colors menu handlers
       } else if(s.equals("ColorsColor")){
//           ppmgr.setColorScheme("Standard");
       } else if(s.equals("ColorsMono")){
//           pm.setColorScheme("Monochrome");

       //Graphs menu handlers
       } else if(s.equals("GraphsInterpolate")){
           JCheckBoxMenuItem i = cmiGraphsInterpolate;
           if(i.isSelected())
               style |= PanelEvent.GS_MISSINGPOINTS;
           else
               style &= ~(PanelEvent.GS_MISSINGPOINTS);
           ppmgr.setStyle(style);
       } else if(s.equals("GraphsDrawLocator")){
           JCheckBoxMenuItem i = cmiGraphsDrawLocator;
           if(i.isSelected())
               style |= PanelEvent.GS_LOCATOR;
           else
               style &= ~(PanelEvent.GS_LOCATOR);
           ppmgr.setStyle(style);
       } else if(s.equals("GraphsFollowCurve")){
           JCheckBoxMenuItem i = cmiGraphsFollowCurve;
           if(i.isSelected())
               style |= PanelEvent.GS_STICKYLOCATOR;
           else
               style &= ~(PanelEvent.GS_STICKYLOCATOR);
           ppmgr.setStyle(style);
       } else if(s.equals("OpaqueCoords")){
           JCheckBoxMenuItem i = cmiOpaqueCoords;
           if(i.isSelected())
               style |= PanelEvent.GS_OPAQUECOORDS;
           else
               style &= ~(PanelEvent.GS_OPAQUECOORDS);
           ppmgr.setStyle(style);

       //Table menu
       } else if(s.equals("PropTreeOnForm")){
           JCheckBoxMenuItem i = cmiPropListOnForm;
           if(e.getSource() != i) i.setSelected(!i.isSelected());
           parent.toggleTreeOnForm(i.isSelected());
       } else if(s.equals("AtomicTableOnForm")){
           JCheckBoxMenuItem i = cmiTableOnForm;
           if(e.getSource() != i) i.setSelected(!i.isSelected());
           parent.toggleTableOnForm(i.isSelected());

       //Help menu
       } else if(s.equals("HelpAboutVM")){
           parent.OnHelpAboutVM();
       } else if(s.equals("HelpAbout")){
           parent.OnHelpAbout();
       } else if(s.indexOf('.') > -1) {
           try {
               UIManager.setLookAndFeel(s);
	    	    SwingUtilities.updateComponentTreeUI(parent);
               ppmgr.updateComponentTreeUI();
               SwingUtilities.updateComponentTreeUI(mb);
           } catch(Throwable t) {t.printStackTrace();}
       }
   }
}
