import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import java.awt.datatransfer.*;

public class AllElementInfo extends JScrollPane implements ActionListener, IPanelListener {
   private Hashtable elements, types, classes, states;
   private PropertyPanelManager ppmgr;
   private DatabaseManager dbmgr;
   private ConfigManager cfgmgr;
   private JTable j = new JTable();

   private JMenuItem miCopyToClipboard = new JMenuItem("Copy to Clipboard...", 'C');
   private JMenuItem miPrintGraph = new JMenuItem("Print Text...", 'P');
   private JMenu pmContext = new JCoolMenu("Panel");

   private int currSelection = -1;

   public AllElementInfo(PropertyPanelManager pp, DatabaseManager d, ConfigManager c) {
       super();
       dbmgr = d;
       ppmgr = pp;
       cfgmgr = c;

       elements = dbmgr.getElements();
       types = dbmgr.getTypes();
       classes = dbmgr.getClasses();
       states = dbmgr.getStates();

       Font f = j.getFont();
       j.setFont(new Font(f.getName(), 0, 20));
       j.setRowHeight(j.getRowHeight()+10);
       j.setSelectionMode(0);
       setViewportView(j);
       j.setCellSelectionEnabled(false);

       if(cfgmgr.canGetClipboard()) {
           miCopyToClipboard.addActionListener(this);
           miCopyToClipboard.setActionCommand("CopyToClipboard");
           pmContext.add(miCopyToClipboard);
       }

       if(cfgmgr.canPrint()) {
           miPrintGraph.addActionListener(this);
           miPrintGraph.setActionCommand("FilePrintTable");
           pmContext.add(miPrintGraph);
       }
       pmContext.setMnemonic('P');
   }

   Object [][] data;

   TableModel dataModel = new AbstractTableModel() {
       // Take the dummy data from SwingSet.
       final String[] names = {"Property", "Value"};

       // These methods always need to be implemented.
       public int getColumnCount() { return names.length; }
       public int getRowCount() { return data.length;}
       public Object getValueAt(int row, int col) {return data[row][col];}

       // The default implementations of these methods in
       // AbstractTableModel would work, but we can refine them.
       public String getColumnName(int column) {return names[column];}
       public Class getColumnClass(int col) {return getValueAt(0,col).getClass();}
       public boolean isCellEditable(int row, int col) {return false;}
       public void setValueAt(Object aValue, int row, int column) {}
   };

   public void setAtom(PanelEvent pe){

       TElement elem = pe.getElement();

       Object[][] d = new Object[NUM_CLASSES][2];

       for(int i=0;i<NUM_CLASSES;i++){
           d[i][0] = getCategories(i);
           d[i][1] = retrieveData(elem, i, dbmgr);
       }

       data = d;
       j.setModel(dataModel);
       j.repaint();
       currSelection = elem.AtomicNumber;
   }

   public void onActivate(PanelEvent pe) {
       ppmgr.addMenu(pmContext);
   }
   public void onDeactivate(PanelEvent pe) {
       ppmgr.removeMenu(pmContext);
   }

   public void actionPerformed(ActionEvent e){
       String s = e.getActionCommand();
       if(s.equals("CopyToClipboard")) {
           OnCopyToClipboard();
       } else if (s.equals("FilePrintTable")) {
       	OnFilePrintTable();
       }
   }
   private void OnCopyToClipboard() {
       StringSelection ss = new StringSelection(
           getAtomInfoAsText(currSelection, dbmgr)
       );

       Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
       c.setContents(ss, ss);
   }

   public static String getAtomInfoAsText(int number, DatabaseManager dbmgr) {
       return getAtomInfoAsText((TElement)dbmgr.getElements().get(new Integer(number)), dbmgr);
   }

   public static String getAtomInfoAsText(TElement elem, DatabaseManager dbmgr) {
       if(elem == null) return null;

       StringBuffer sb = new StringBuffer();

       for(int i=0;i<NUM_CLASSES;i++){
           sb.append(getCategories(i));
           sb.append("\t\t");
           sb.append(retrieveData(elem, i, dbmgr));
           sb.append("\r\n");
       }
       return sb.toString();
   }


/*   private static String extractData(int number, int what) {
       TElement elem = (TElement)elements.get(new Integer(number));
       if(elem == null) return null;

       return retrieveData(elem, what);
   }
*/
   private static String retrieveData(TElement elem, int what, DatabaseManager dbmgr) {
       switch(what) {
           case 0:  return elem.Name;
           case 1:  return Integer.toString(elem.AtomicNumber);
           case 2:  return elem.Symbol;
           case 3:  return TElementType.getTypeName(elem.ElementType, dbmgr.getTypes());
           case 4:  return TState.getStateName(elem.State, dbmgr.getStates());
           case 5:  return Float.toString(elem.Mass);
           case 6:  return Integer.toString(elem.RelativeMass);
           case 7:  return procFloat(elem.Melting);
           case 8:  return procFloat(elem.Boiling);
           case 9:  return elem.Valency;
           case 10: return (elem.DateDiscovered == 0?"Ancient":Integer.toString(elem.DateDiscovered));
           case 11: return elem.Discoverer;
           case 12: return elem.NameOrigin;
           case 13: return elem.Uses;
           case 14: return elem.ObtainedFrom;
           case 15: return elem.ElectronConfig;
           case 16: return procFloat(elem.Electronegativity);
           case 17: return procFloat(elem.Density);
           case 18: return procFloat(elem.Ionization);
           case 19: return procFloat(elem.SpecificHeat);
           case 20: return procFloat(elem.Vaporization);
           case 21: return procFloat(elem.AtomicRadii);
           case 22: return TClass.getClassName(elem.ClassType, dbmgr.getClasses());
           case 23: return procFloat(elem.Sanderson);
           case 24: return procFloat(elem.Rochow);
           case 25: return procFloat(elem.Mulliken);
           case 26: return procFloat(elem.Allen);
           case 27: return Float.toString(elem.gperkg);

           case 28: return procFloat(elem.zeff_s1);
           case 29: return procFloat(elem.zeff_s2);
           case 30: return procFloat(elem.zeff_p2);
           case 31: return procFloat(elem.zeff_s3);
           case 32: return procFloat(elem.zeff_p3);
           case 33: return procFloat(elem.zeff_d3);
           case 34: return procFloat(elem.zeff_s4);
           case 35: return procFloat(elem.zeff_p4);
           case 36: return procFloat(elem.zeff_d4);
           case 37: return procFloat(elem.zeff_f4);
           case 38: return procFloat(elem.zeff_s5);
           case 39: return procFloat(elem.zeff_p5);
           case 40: return procFloat(elem.zeff_d5);
           case 41: return procFloat(elem.zeff_s6);
           case 42: return procFloat(elem.zeff_p6);
           case 43: return procFloat(elem.zeff_s7);

           case 44: return procFloat(elem.affinity);
           case 45: return procFloat(elem.molar_volume);
           case 46: return procFloat(elem.sound_velocity);
           case 47: return elem.abundances;
           case 48: return elem.hazards;

           case 49: return procFloat(elem.UniverseByWeight);
           case 50: return procFloat(elem.UniverseByAtom);
           case 51: return procFloat(elem.SunByWeight);
           case 52: return procFloat(elem.SunByAtom);
           case 53: return procFloat(elem.MeteoritesByWeight);
           case 54: return procFloat(elem.MeteoritesByAtom);
           case 55: return procFloat(elem.CrustalRocksByWeight);
           case 56: return procFloat(elem.CrustalRocksByAtom);
           case 57: return procFloat(elem.SeaWaterByWeight);
           case 58: return procFloat(elem.SeaWaterByAtom);
           case 59: return procFloat(elem.StreamByWeight);
           case 60: return procFloat(elem.StreamByAtom);
           case 61: return procFloat(elem.HumanByWeight);
           case 62: return procFloat(elem.HumanByAtom);

           case 63: return procFloat(elem.CovalentRadius);
           case 64: return elem.CASRegistry;
           case 65: return elem.Crystal;
           case 66: return procFloat(elem.AtomicVol);
           case 67: return procFloat(elem.HVaporization);
           case 68: return procFloat(elem.ThermConductivity);
           case 69: return procFloat(elem.HFusion);
           case 70: return procFloat(elem.PIonPotent);
           case 71: return procFloat(elem.SIonPotent);
           case 72: return procFloat(elem.TIonPotent);
       }
       throw new IllegalArgumentException("Categories range from 0 to "+(NUM_CLASSES-1)+".");
   }

   private static String procFloat(float value) {
       return ( value==-1.0?"Unknown":Float.toString(value) );
   }

   private static final int NUM_CLASSES = 73;

   private static String getCategories(int i) {
       if((i<0)||(i>=NUM_CLASSES)) throw new IllegalArgumentException("Categories range from 0 to "+(NUM_CLASSES-1)+".");
       return categories[i];
   }

   private static final String categories[] = {
       "Name",
       "Atomic Number",
       "Symbol",
       "Element Type",
       "State",
       "Mass (amu)",
       "Relative Mass",
       "Melts at (K)",
       "Boils at (K)",
       "Valency",
       "Discovery Date",
       "Discoverer",
       "Name Origin",
       "Uses",
       "Obtained From",
       "Electron Config",
       "Electronegativity",
       "Density (g/cm^3)",
       "Ionization Energy (eV)",
       "Specific Heat (cal/g K)",
       "Vaporization (Kcal / g*atom)",
       "Atomic Radii (ang)",
       "Class Type",
       "Sanderson Electronegativity",
       "Rochow Electronegativity",
       "Mulliken Electronegativity",
       "Allen Electronegativity",
       "g of element / kg of human",

       "Zeff for 1s",
       "Zeff for 2s",
       "Zeff for 2p",
       "Zeff for 3s",
       "Zeff for 3p",
       "Zeff for 3d",
       "Zeff for 4s",
       "Zeff for 4p",
       "Zeff for 4d",
       "Zeff for 4f",
       "Zeff for 5s",
       "Zeff for 5p",
       "Zeff for 5d",
       "Zeff for 6s",
       "Zeff for 6p",
       "Zeff for 7s",

       "Electron Affinity (kJ/mol)",
       "Molar Volume (cm^3)",
       "Resistivity (u-ohms)",
       "Abundances",
       "Hazards",

       "Universe (ppb by Weight)",
       "Universe (ppb by Atom)",
       "Sun (ppb by Weight)",
       "Sun (ppb by Atom)",
       "Meteorites (ppb by Weight)",
       "Meteorites (ppb by Atom)",
       "CrustalRocks (ppb by Weight)",
       "CrustalRocks (ppb by Atom)",
       "SeaWater (ppb by Weight)",
       "SeaWater (ppb by Atom)",
       "Stream (ppb by Weight)",
       "Stream (ppb by Atom)",
       "Human (ppb by Weight)",
       "Human (ppb by Atom)",

       "Covalent Radius ()",
       "CAS Registry Number",
       "Crystal Structure",
       "Atomic Volume (cm^3/mol)",
       "Heat of Vaporization (kJ/mol)",
       "Thermal Conductivity (W/cmK)",
       "Heat of Fusion (kJ/mol)",
       "1st Ion Potential (V)",
       "2nd Ion Potential (V)",
       "3rd Ion Potential (V)",

       ""
   };

   private void OnFilePrintTable() {
   }

   public String toString() { return "All Properties"; }   

   public void setStyle(PanelEvent pe) {}

   public void updateUI() {
       super.updateUI();
       if(pmContext != null) pmContext.updateUI();
   }
}
