/*
    Histogram filtering tool.
    Copyright (C) 2006 Darrick Wong

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef HIST_H_
#define HIST_H_

typedef struct {
	char *label;
	int *samples;
	int samples_taken;
} histogram_t;

double getNumber(const char *str);
void print_help();
histogram_t *allocateHistograms(int count, int samples);
void freeHistograms(histogram_t **ptr, int count, int samples);
void trim(char *str);
int countSamples(const char *fname, histogram_t *record, double begin, double end, double incr, int column);

#define TRUE 1
#define FALSE 0
#define H_PROGNAME	"hist"
#define LINESIZE 8192

#define FRAME(a,b,x) ((x) > (a) ? ((x) < (b) ? TRUE : FALSE) : FALSE )

#endif //HIST_H
