/*
    Utility functions for bogodisk
    Copyright (C) 2014 Darrick Wong

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef UTIL_H_
#define UTIL_H_

uint64_t get_number(const char *string);
void get_size_and_block_size(const char *fname, uint64_t *size,
			     uint32_t *block_size, int *is_blkdev);
int seed_random(void);
uint64_t get_randnum_align(uint64_t min, uint64_t max, uint64_t align);
long ioprio_set(int which, int who, int ioprio);
int bump_priority(void);

#endif
