/* dump various blocks in a file */
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#define STR_SIZE 512

int main(int argc, char *argv[])
{
	size_t block_size, block_num;
	char str[STR_SIZE];
	char *buf;
	FILE *fp;

	if (argc != 3) {
		printf("Usage: %s blocksize file\n", argv[0]);
		return 0;
	}

	block_size = strtoul(argv[1], NULL, 0);
	if (errno) {
		perror(argv[1]);
		return 1;
	}

	fp = fopen(argv[2], "r");
	if (!fp) {
		perror(argv[2]);
		return 2;
	}

	buf = malloc(block_size);
	if (!buf) {
		perror("malloc");
		fclose(fp);
		return 3;
	}

	while (fgets(str, STR_SIZE, stdin)) {
		block_num = strtoul(str, NULL, 0);
		if (errno) {
			perror(str);
			continue;
		}

		if (fseek(fp, block_num * block_size, SEEK_SET) < 0) {
			perror(argv[2]);
			continue;
		}

		if (fread(buf, block_size, 1, fp) != 1) {
			perror(argv[2]);
			continue;
		}

		fwrite(buf, block_size, 1, stdout);
	}

	free(buf);
	fclose(fp);
	return 0;
}
