/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class PropertyPanelManager
implements TreeSelectionListener {
    private DatabaseManager dbmgr;
    private JTree tree;
    private DefaultTreeModel dtm;
    private Hashtable rootNodes;
    private Vector properties;
    private Container host;
    private JPeriod99 parent;
    private Hashtable elements;
    private int iSelection = -1;
    private TElement teSelection = null;
    private JFrame frmHolder;
    private Container cmpHolder;
    private IPanelListener currA;
    private Component currC;
    private IPanelListener panelListener = null;
    public static final String root = "Root";
    private DefaultMutableTreeNode tnRoot = new DefaultMutableTreeNode("Root");

    public PropertyPanelManager(JTree jTree, DatabaseManager databaseManager, Container container, JPeriod99 jPeriod99) {
        this.tree = jTree;
        this.dbmgr = databaseManager;
        this.host = container;
        this.parent = jPeriod99;
        this.rootNodes = new Hashtable();
        this.properties = new Vector(50);
        this.frmHolder = new JFrame("Holder");
        this.cmpHolder = this.frmHolder.getContentPane();
        this.elements = this.dbmgr.getElements();
        this.host.setLayout(new BorderLayout());
        this.dtm = new DefaultTreeModel(this.tnRoot);
        this.tree.setModel(this.dtm);
        this.rootNodes.put(root, this.tnRoot);
        this.tree.addTreeSelectionListener(this);
        this.tree.setEditable(false);
        this.tree.expandRow(0);
    }

    public void addRootNode(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        this.tnRoot.add(defaultMutableTreeNode);
        this.rootNodes.put(string, defaultMutableTreeNode);
    }

    public void addProperty(IPanelListener iPanelListener) {
        this.properties.addElement(iPanelListener);
        this.addPanelListener(iPanelListener);
    }

    public DefaultMutableTreeNode addPropertyPanel(String string, IPanelListener iPanelListener, Component component) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.rootNodes.get(string);
        if (defaultMutableTreeNode == null) {
            this.addRootNode(string);
        }
        defaultMutableTreeNode = (DefaultMutableTreeNode)this.rootNodes.get(string);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(component);
        if (defaultMutableTreeNode == this.tnRoot) {
            this.tnRoot.insert(defaultMutableTreeNode2, 0);
        } else {
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        this.addProperty(iPanelListener);
        this.cmpHolder.add(component);
        return defaultMutableTreeNode2;
    }

    public void addDefaultPropertyPanel(String string, IPanelListener iPanelListener, Component component) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.addPropertyPanel(string, iPanelListener, component);
        this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        this.valueChanged(null);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        try {
            IPanelListener iPanelListener = (IPanelListener)defaultMutableTreeNode.getUserObject();
            Component component = (Component)defaultMutableTreeNode.getUserObject();
            this.cmpHolder.remove(component);
            if (this.currA != null) {
                this.currA.onDeactivate(new PanelEvent(2000, this, null, 0));
                this.host.remove(this.currC);
                this.cmpHolder.add(this.currC);
            }
            this.host.add("Center", component);
            iPanelListener.onActivate(new PanelEvent(2001, this, null, 0));
            this.currA = iPanelListener;
            this.currC = component;
            component.invalidate();
            component.repaint();
            this.host.invalidate();
            this.host.validate();
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public TElement getSelection() {
        return this.teSelection;
    }

    public void setSelection(TElement tElement) {
        this.setAtom(tElement.AtomicNumber);
    }

    public int getAtom() {
        return this.iSelection;
    }

    public void setAtom(int n) {
        if (null == this.panelListener) {
            return;
        }
        this.iSelection = n;
        this.teSelection = (TElement)this.elements.get(new Integer(n));
        PanelEvent panelEvent = new PanelEvent(2002, this, this.teSelection, 0);
        this.panelListener.setAtom(panelEvent);
    }

    public void setStyle(int n) {
        if (null == this.panelListener) {
            return;
        }
        PanelEvent panelEvent = new PanelEvent(2003, this, null, n);
        this.panelListener.setStyle(panelEvent);
    }

    public void addPanelListener(IPanelListener iPanelListener) {
        this.panelListener = PanelEventMulticaster.add(this.panelListener, iPanelListener);
    }

    public void removePanelListener(IPanelListener iPanelListener) {
        this.panelListener = PanelEventMulticaster.remove(this.panelListener, iPanelListener);
    }

    public void addMenu(JMenu jMenu) {
        JMenuBar jMenuBar = this.parent.getJMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.invalidate();
        jMenuBar.validate();
    }

    public void removeMenu(JMenu jMenu) {
        JMenuBar jMenuBar = this.parent.getJMenuBar();
        jMenuBar.remove(jMenu);
        jMenuBar.repaint();
    }

    public void updateComponentTreeUI() {
        SwingUtilities.updateComponentTreeUI(this.frmHolder);
    }
}

